#ifndef BOARD_H
#define BOARD_H

#include "piece.h"
#include "squares.h"
#include "defs.h"
#include "keys.h"

using namespace std;


const int WCAKS = 8;
const int WCAQS = 4;
const int BCAKS = 2;
const int BCAQS = 1;


class cMaterial;

class cBoard {

    private:
    uint board[BRDSQ];
    uint side;
    uint fifty;
    uint castleperm;
    uint enpas;
    u64  key;
    u64  pawnkey;
    uint ply;

    cBoard( const cBoard & );
        cBoard &operator = ( const cBoard & );

    public:

    cBoard();

    void setside(const uint s);
    void setfifty(const uint f);
    void resetfifty();
    void setcastle(const uint c);
    void updatecastle(const uint bit) { castleperm &= bit; }
    void setenpas(const uint s);
    void setkey(const u64 s);
    void setpawnkey(const u64 s);
    void setpiece(const uint p, const uint s);
    void printboard();
    void logboard();
    void setply(const uint p) { ply = p; }
    void incrply() { ply++; }
    void decrply() { ply--; }

    uint &getply() { return ply; }
    uint &getside() { return side; }
    uint &getpiece(uint &sq){ return board[sq]; }
    uint &getcastle(){ return castleperm; }
    uint &getfifty(){ return fifty; }
    uint &getenpas(){ return enpas; }
    u64  &getkey(){ return key; }
    u64  &getpawnkey(){ return pawnkey; }
    void changeside() {  side^= 1; }
    uint returnply() { return ply; }

    uint *p2board() {return board;}

    void clearboard();

    inline void hashside() { key ^= side_hash_keys[side]; }
    inline void hashenpas() { key ^= enpas_hash_keys[enpas]; }
    inline void hashcastle() { key ^= castle_hash_keys[castleperm]; }
    inline void hashpiece(const uint &p, const uint &sq) { key ^= piece_hash_keys[p][sq]; }
    inline void hashpawn(const uint &p, const uint &sq) { pawnkey ^= piece_hash_keys[p][sq]; }

};

inline bool sideok(const uint s) {return (s==cW||s==cB);}
inline bool fiftyok(const uint f) {return (f>=0 && f<=100);}
inline bool castleok(const uint c) {return (c>=0 && c<= 15);}
inline bool enpasok(const uint s) {return (onbrd(s)==true || s==NOSQ);}

extern bool position_check(cBoard &b,  cMaterial &m);
extern bool checkkey(cBoard &b);
extern u64 genhashkey(cBoard &b);
extern u64 genpawnkey(cBoard &b);


#endif
